<?php

ini_set('session.cookie_httponly', true); // Sólo permitir cookies de sesión vía HTTP
ini_set('session.cookie_secure', true); // Solo enviar cookies de sesión a través de conexiones HTTPS
session_name("CON");
session_start();

// Verificar si el usuario no está logeado
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {

    // Si no está logeado, redirigir al formulario de inicio de sesión
    header("location: /Congreso/Sesion/login.html");
    exit;
}


require_once __DIR__ . "/Conexiones/Conexion.php";

// Recuperar eventos en curso y su capacidad
$sql = "SELECT ID, name_evento, capacidad FROM evento WHERE estado = 'EN CURSO'";
$result = $conn->query($sql);


/*/ Recuperar eventos en curso
$sql = "SELECT ID, name_evento FROM evento WHERE estado = 'EN CURSO'";
$result = $conn->query($sql);*/

// Cerrar conexión
$conn->close();
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles3.css">
    <link rel="icon" href="/Congreso/educacion.png" type="image/x-icon">

    <title>Nuevo Participante</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    
</head>

<body class="fade-in">
    <header class="header">
        <div class="logo">Agregar Participante</div>
        <nav class="navbar">
            <ul>
                <li class="corner-left-bottom"><a href="javascript:history.back()">Volver</a></li>
            </ul>
        </nav>
    </header>
    <p></p>

    <form action="Funcion_Agregar_Participante.php" method="POST">
        <div id="step1">

            <label for="Evento">Evento:</label>
            <select id="Evento" name="Evento" required onchange="updateParticipantes()">
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<option value='" . $row["ID"] . "' data-capacidad='" . $row["capacidad"] . "'>" . $row["name_evento"] . "</option>";
                    }
                } else {
                    echo "<option value=''>No hay eventos disponibles</option>";
                }
                ?>
            </select><br><br>


            <p id="participantes-info"></p>
            <p></p>


            <label for="sucursal">Sucursal:</label><br>
            <select id="sucursal" name="sucursal" required>
                <option value="">Selecciona una sucursal</option>
                <option value="DIMEGSA">DIMEGSA</option>
                <option value="DEASA">DEASA</option>
                <option value="AIESA">AIESA</option>
                <option value="SEGSA">SEGSA</option>
                <option value="FESA">FESA</option>
                <option value="TAPATIA">TAPATIA</option>
                <option value="GABSA">GABSA</option>
                <option value="ILUMINACION">ILUMINACION</option>
                <option value="VALLARTA">VALLARTA</option>
            </select><br><br>

            <label for="Vendedor">Vendedor:</label>
            <input type="text" id="Vendedor" name="Vendedor" required><br><br>

            <label for="Nombre">Nombre del participante:</label>
            <input type="text" id="Nombre" name="Nombre" required><br><br>

            <label for="Proveedor">Razon Social (Proveedor):</label>
            <input type="text" id="Proveedor" name="Proveedor" required><br><br>


            <label for="rfc">RFC del Participante:</label>
            <input type="text" id="rfc" name="rfc" required><br><br>


            <label for="puesto">Puesto:</label>
            <select id="puesto" name="puesto" required>
                <option value="">Selecciona un puesto</option>
                <option value="Ingeniero">Ingeniero</option>
                <option value="Electricista">Electricista</option>
                <option value="Ayudante">Ayudante</option>
                <option value="Supervisor">Supervisor</option>
                <option value="Compras">Compras</option>
                <option value="Mantenimiento">Mantenimiento</option>
                <option value="Jefe de Área">Jefe de Área</option>
                <option value="Otro">Otro</option>
            </select><br><br>


            <label for="Telefono">Teléfono:</label>
            <input type="text" id="Telefono" name="Telefono" required pattern="\d{10}" maxlength="10"
                title="Ingresa un número de 10 dígitos"><br><br>

            <!-- <input type="submit" value="Agregar Participante">-->

            <button type="button" id="btnContinuar" style="background-color: #f59f2fff; color: white; border: none; padding: 12px 24px; font-size: 16px; cursor: pointer; border-radius: 4px; transition: background-color 0.3s;">
                Continuar → Seleccionar actividades
            </button>
        </div>


        <!-- ===== PASO 2: AGENDA (se carga por AJAX) ===== -->
        <div id="step2" style="display:none; margin-top:24px;">
            <h3>Selecciona actividades (se bloquearán los solapes)</h3>
            <div id="agendaContainer" style="margin:12px 0;"></div>
            <div style="display:flex; gap:12px; justify-content:center; margin-top:20px;">
                <button type="button" id="btnVolver" style="background-color: #3498db; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; transition: background-color 0.3s;">
                    ← Volver
                </button>
                <button type="submit" style="background-color: #2ecc71; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; transition: background-color 0.3s;">
                    Guardar participante
                </button>
            </div>
        </div>
    </form>

    <script>
        function updateParticipantes() {
            var eventoID = $('#Evento').val();
            var capacidad = $('#Evento option:selected').data('capacidad');

            $.ajax({
                url: 'get_participantes.php',
                type: 'POST',
                data: { evento_id: eventoID },
                success: function (data) {
                    var participantes = parseInt(data);
                    var disponibles = capacidad - participantes;
                    $('#participantes-info').text('Participantes registrados: ' + participantes + ' / ' + capacidad + '. Quedan ' + disponibles + ' espacios disponibles.');

                    // Verificar si se ha alcanzado la capacidad
                    if (disponibles <= 0) {
                        alert('Este evento ha alcanzado su capacidad máxima.');
                        $('input[type="submit"]').prop('disabled', true);
                    } else {
                        $('input[type="submit"]').prop('disabled', false);
                    }
                }
            });
        }
    </script>

    <!-- ... encabezado y PHP igual ... -->

   

    <script>
        // Paso 1 -> Paso 2
        document.getElementById('btnContinuar').addEventListener('click', function () {
            // Validaciones mínimas
            const req = ['Evento', 'sucursal', 'Vendedor', 'Nombre', 'Proveedor', 'rfc', 'puesto', 'Telefono'];
            for (const id of req) {
                const el = document.getElementById(id);
                if (!el || !el.value.trim()) { el.focus(); return; }
            }

            const eventoID = document.getElementById('Evento').value;
            // Cargar agenda real del evento (sin 'Vacio')
            $('#agendaContainer').load('get_agenda_evento.php?evento=' + encodeURIComponent(eventoID), function () {
                // Activar bloqueo de solapes cuando ya esté cargada
                activarBloqueoSolapes();
            });

            document.getElementById('step1').style.display = 'none';
            document.getElementById('step2').style.display = 'block';
        });

        // Volver
        document.getElementById('btnVolver').addEventListener('click', function () {
            document.getElementById('step2').style.display = 'none';
            document.getElementById('step1').style.display = 'block';
        });

        // Bloqueo de solapes en cliente
        function toMin(h) { const [H, M] = h.split(':').map(Number); return H * 60 + M; }
        function parseRange(r) { const [a, b] = r.split('-'); return [toMin(a), toMin(b)]; }

        function activarBloqueoSolapes() {
            const chks = document.querySelectorAll('.chk-slot');
            function refreshLocks() {
                chks.forEach(c => c.disabled = false); // habilitar todo
                const chosenByDate = {};
                chks.forEach(c => {
                    if (c.checked) {
                        const f = c.dataset.fecha;
                        const [i, fm] = parseRange(c.dataset.horario);
                        (chosenByDate[f] ||= []).push([i, fm]);
                    }
                });
                chks.forEach(c => {
                    if (c.checked) return;
                    const f = c.dataset.fecha;
                    if (!chosenByDate[f]) return;
                    const [i, fm] = parseRange(c.dataset.horario);
                    const clash = chosenByDate[f].some(([a, b]) => (i < b && a < fm));
                    if (clash) c.disabled = true;
                });
            }
            chks.forEach(c => c.addEventListener('change', refreshLocks));
        }
    </script>

</body>

</html>