<?php
// Establecer la conexión a la base de datos
require_once __DIR__ . "/Conexiones/Conexion.php";

// Obtener el ID del participante y de la clase desde la solicitud POST
$idParticipante = isset($_POST['id_participante']) ? intval($_POST['id_participante']) : 0;
$idClase = isset($_POST['id_clase']) ? intval($_POST['id_clase']) : 0;

if ($idParticipante <= 0 || $idClase <= 0) {
    echo "Modo Lectura de QR.";
    exit;
}

// Verificar si el participante ya está en la clase
$sqlVerificar = "SELECT COUNT(*) FROM clase WHERE ID_Participante = ? AND ID_Agenda = ?";
$stmtVerificar = $conn->prepare($sqlVerificar);
$stmtVerificar->bind_param("ii", $idParticipante, $idClase);
$stmtVerificar->execute();
$stmtVerificar->bind_result($count);
$stmtVerificar->fetch();
$stmtVerificar->close();

if ($count > 0) {
    echo "El participante ya está agregado en esta clase.";
    $conn->close();
    exit;
}

// Obtener la capacidad máxima de la clase y el número actual de participantes
$sqlCapacidad = "
    SELECT A.capacidad, COUNT(C.ID) as total_participantes 
    FROM actividades A 
    JOIN agenda B ON A.Actividad = B.Actividad 
    LEFT JOIN clase C ON B.ID = C.ID_Agenda 
    WHERE B.ID = ? AND B.ID_Evento = A.ID_Evento";

$stmtCapacidad = $conn->prepare($sqlCapacidad);
$stmtCapacidad->bind_param("i", $idClase);
$stmtCapacidad->execute();
$resultCapacidad = $stmtCapacidad->get_result();

if ($resultCapacidad->num_rows > 0) {
    $rowCapacidad = $resultCapacidad->fetch_assoc();
    $capacidadMaxima = $rowCapacidad['capacidad'];
    $totalParticipantes = $rowCapacidad['total_participantes'];

    // Verificar si la clase está llena
    if ($totalParticipantes >= $capacidadMaxima) {
        echo "No se puede agregar más participantes, la clase está llena.";
        $stmtCapacidad->close();
        $conn->close();
        exit;
    }
} else {
    echo "No se encontró la clase especificada.";
    $stmtCapacidad->close();
    $conn->close();
    exit;
}

// Consulta para agregar el participante a la clase
$sqlAgregar = "INSERT INTO clase (ID_Participante, ID_Agenda, Tipo_Inscripcion) VALUES (?, ?, 1)";
$stmtAgregar = $conn->prepare($sqlAgregar);
$stmtAgregar->bind_param("ii", $idParticipante, $idClase);


if ($stmtAgregar->execute()) {
    echo "Participante agregado exitosamente. Presione 'Aceptar' o ingrese otro código.";
} else {
    echo "Error al agregar el participante: " . $conn->error;
}

// Cerrar conexiones y declaraciones
$stmtAgregar->close();
$conn->close();
?>
