<?php

// Iniciar la sesión de forma segura

ini_set('session.cookie_httponly', true); // Sólo permitir cookies de sesión vía HTTP
ini_set('session.cookie_secure', true); // Solo enviar cookies de sesión a través de conexiones HTTPS
session_name("CON");
session_start();

// Verificar si el usuario no está logeado
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || $_SESSION["Rol"] === "Vendedor") {
 
    // Si no está logeado, redirigir al formulario de inicio de sesión
    header("location: /Congreso/Sesion/login.html");
    exit;
}

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clase</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
       <link rel="icon" href="/Congreso/educacion.png" type="image/x-icon">
<style>
body {
  font-family: 'Segoe UI', sans-serif;
    background: radial-gradient(circle at center, #0d1c3b, #1e2a78);
  margin: 0;
  padding: 0;
  color: #333;
}

.fade-in {
  animation: fadeIn 0.6s ease-in-out;
}

@keyframes fadeIn {
  from {opacity: 0;}
  to {opacity: 1;}
}



.container {
  margin-left: 250px;
  padding: 30px;
}

.titulo {
  font-size: 28px;
  margin-bottom: 10px;
  color: #d17224ff;
}

#busqueda {
  padding: 10px;
  font-size: 16px;
  border: 1px solid #bbb;
  border-radius: 8px;
  width: 100%;
  max-width: 400px;
  background-color: #f9f9f9;
  margin-bottom: 20px;
}

form#agregarParticipanteForm {
  background-color: #ffffff;
  border: 1px solid #ddd;
  border-radius: 12px;
  padding: 25px;
  max-width: 500px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  margin-top: 40px;
}

form#agregarParticipanteForm input[type="text"] {
  width: 100%;
  padding: 12px;
  font-size: 16px;
  border: 1px solid #ccc;
  border-radius: 8px;
  margin-bottom: 15px;
}

form#agregarParticipanteForm .button {
  background-color: #2b8df4;
  color: white;
  padding: 12px 20px;
  border: none;
  font-size: 16px;
  border-radius: 8px;
  cursor: pointer;
  transition: background 0.3s ease;
}

form#agregarParticipanteForm .button:hover {
  background-color: #1f6edb;
}

#resultado {
  margin-top: 20px;
  color: #e0e0e0;
}

/* Estilos para los registros en #resultado */
.registro-participante {
  background: #fff;
  padding: 15px 20px;
  border-radius: 8px;
  margin-bottom: 10px;
  border: 1px solid #e0e0e0;
  box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}
</style>




</head>
<body class = "fade-in">

<div class="sidebar">
    <ul>
       <!-- <li><a href="Agregar_Participante.php">Agregar participante</a></li>-->
        <li class="corner-left-bottom">
            <a href="javascript:window.history.back();">Volver</a>
        </li>
    </ul>
</div>

<div class="container">
    <h2 class="titulo">Participantes</h2>

    <!-- Campo de búsqueda -->
  <input type="text" id="busqueda" placeholder="Buscar por nombre, sucursal, vendedor, etc."disabled>

    <p></p>

    <div id="resultado">
        <!-- Aquí se mostrarán los resultados de la búsqueda -->
    </div>

    <!-- Formulario para agregar participante -->
   <h2 class="titulo">Escaneo / Control</h2>

<div style="margin:10px 0; color:#e0e0e0">
  <label><input type="radio" name="modo" value="asistencia" checked> Tomar asistencia</label>
  <label style="margin-left:16px"><input type="radio" name="modo" value="agregar"> Agregar a la clase</label>
</div>

<form id="scanForm">
  <input type="text" id="idParticipante" placeholder="Escanea el QR aquí" required>
  <input type="hidden" id="idClase" value="<?php echo $id; ?>">
  <button class="button" type="submit">Procesar</button>
</form>


</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
  const busquedaInput = document.getElementById("busqueda");
  const idParticipanteInput = document.getElementById("idParticipante");
  const scanForm = document.getElementById("scanForm");
  const idClase = document.getElementById("idClase").value;

  function realizarBusqueda() {
    const busqueda = busquedaInput.value;
    const xhr = new XMLHttpRequest();
    xhr.open("POST", "Consultar_Clase.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function() {
      if (xhr.readyState == 4 && xhr.status == 200) {
        document.getElementById("resultado").innerHTML = xhr.responseText;
      }
    };
    xhr.send("busqueda=" + encodeURIComponent(busqueda) + "&id=" + encodeURIComponent(idClase));
  }
  realizarBusqueda();

  // Extraer ID del QR (ajústalo si tu QR cambia)
 function extraerId(cadena) {
  if (!cadena) return '';

  // Normaliza: separa por Ñ o saltos de línea
  const tokens = cadena.split(/Ñ|\n|\r/).map(s => s.trim()).filter(Boolean);

  // Caso estándar: ... "ID", "1186", "Evento", "28", ...
  for (let i = 0; i < tokens.length; i++) {
    if (/^ID$/i.test(tokens[i])) {
      const next = tokens[i + 1] || '';
      const m = next.match(/\d+/);
      if (m) return m[0];
    }
  }

  // Caso pegado: "ID1186" o "ID: 1186"
  for (const t of tokens) {
    const m = t.match(/ID[:\s]*([0-9]+)/i);
    if (m) return m[1];
  }

  // Último recurso: busca "ID ... 1186" en todo el string
  let m = cadena.match(/ID\D*?(\d+)/i);
  if (m) return m[1];

  // Súper fallback: primer número “grande” que aparezca
  m = cadena.match(/\b(\d{3,})\b/);
  return m ? m[1] : '';
}


  function agregarParticipante(idParticipante) {
    const xhr = new XMLHttpRequest();
    xhr.open("POST", "Agregar_Participante_Manual.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function() {
      if (xhr.readyState == 4) {
        alert(xhr.responseText);
        realizarBusqueda();
        idParticipanteInput.value = '';
        idParticipanteInput.focus();
      }
    };
    xhr.send("id_participante=" + encodeURIComponent(idParticipante) + "&id_clase=" + encodeURIComponent(idClase));
  }

  function marcarAsistencia(idParticipante) {
    const xhr = new XMLHttpRequest();
    xhr.open("POST", "Marcar_Asistencia.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function() {
      if (xhr.readyState == 4) {
        alert(xhr.responseText);
        realizarBusqueda(); // refresca lista con check de asistencia
        idParticipanteInput.value = '';
        idParticipanteInput.focus();
      }
    };
    xhr.send("id_participante=" + encodeURIComponent(idParticipante) + "&id_clase=" + encodeURIComponent(idClase));
  }

  // Envío (lector QR suele mandar Enter)
  scanForm.addEventListener("submit", function(e) {
    e.preventDefault();
    const raw = idParticipanteInput.value.trim();
    if (!raw) return;
    const id = extraerId(raw);
    if (!id) { alert("No se pudo leer el ID del QR."); return; }

    const modo = document.querySelector('input[name="modo"]:checked').value;
    if (modo === "agregar") agregarParticipante(id);
    else marcarAsistencia(id);
  });

  // Si usas buscador luego, aquí lo vuelves a habilitar
  // busquedaInput.addEventListener("input", realizarBusqueda);
});
</script>


</body>
</html>
