<?php

// Iniciar la sesión de forma segura

ini_set('session.cookie_httponly', true); // Sólo permitir cookies de sesión vía HTTP
ini_set('session.cookie_secure', true); // Solo enviar cookies de sesión a través de conexiones HTTPS
session_name("CON");
session_start();

// Verificar si el usuario no está logeado
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || $_SESSION["Rol"] === "Vendedor") {

    // Si no está logeado, redirigir al formulario de inicio de sesión
    header("location: /Congreso/Sesion/login.html");
    exit;
}

require_once __DIR__ . "/Conexiones/Conexion.php";

$id_evento = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Consulta para obtener las actividades y total de participantes
/*$sql_actividades = "
  SELECT 
        a.Actividad, 
        COUNT(c.ID_Participante) AS total_participantes
    FROM 
        clase c
    JOIN 
        agenda ag ON c.ID_Agenda = ag.ID
    JOIN 
        actividades a ON ag.Actividad = a.Actividad
    WHERE 
        a.ID_Evento = ?
    GROUP BY 
        a.Actividad
    ORDER BY 
        total_participantes DESC;";*/

$sql_actividades = "
  SELECT 
    a.Actividad, 
    COUNT(DISTINCT c.ID_Participante) AS total_participantes
FROM 
    clase c
JOIN 
    agenda ag ON c.ID_Agenda = ag.ID
JOIN 
    actividades a ON ag.Actividad = a.Actividad
WHERE 
    a.ID_Evento = ?
GROUP BY 
    a.Actividad
ORDER BY 
    total_participantes DESC;
";

$stmt_actividades = $conn->prepare($sql_actividades);
$stmt_actividades->bind_param("i", $id_evento);
$stmt_actividades->execute();
$result_actividades = $stmt_actividades->get_result();

// Consulta para obtener la participación por día
$sql_participacion_dia = "
    SELECT 
        DATE(ag.Fecha) AS fecha,
        COUNT(DISTINCT c.ID_Participante) AS total_participantes
    FROM 
        clase c
    JOIN 
        agenda ag ON c.ID_Agenda = ag.ID
    WHERE 
        ag.ID_Evento = ?
    GROUP BY 
        fecha
    ORDER BY 
        fecha;";
$stmt_participacion_dia = $conn->prepare($sql_participacion_dia);
$stmt_participacion_dia->bind_param("i", $id_evento);
$stmt_participacion_dia->execute();
$result_participacion_dia = $stmt_participacion_dia->get_result();

// Consulta para obtener la participación por hora
$sql_participacion_hora = "
    SELECT 
        DATE(ag.Fecha) AS fecha,
        HOUR(ag.Horario) AS hora,
        COUNT(DISTINCT c.ID_Participante) AS total_participantes
    FROM 
        clase c
    JOIN 
        agenda ag ON c.ID_Agenda = ag.ID
    WHERE 
        ag.ID_Evento = ?
    GROUP BY 
        fecha, hora
    ORDER BY 
        fecha, hora;";
$stmt_participacion_hora = $conn->prepare($sql_participacion_hora);
$stmt_participacion_hora->bind_param("i", $id_evento);
$stmt_participacion_hora->execute();
$result_participacion_hora = $stmt_participacion_hora->get_result();


// Consulta para obtener la cantidad de días que asistió cada participante
$sql_dias_asistencia = "
    SELECT 
        ID_Participante, 
        COUNT(DISTINCT DATE(ag.Fecha)) AS dias_asistidos
    FROM 
        clase c
    JOIN 
        agenda ag ON c.ID_Agenda = ag.ID
    WHERE 
        ag.ID_Evento = ?
    GROUP BY 
        ID_Participante;";
$stmt_dias_asistencia = $conn->prepare($sql_dias_asistencia);
$stmt_dias_asistencia->bind_param("i", $id_evento);
$stmt_dias_asistencia->execute();
$result_dias_asistencia = $stmt_dias_asistencia->get_result();

// Crear un array para contar la cantidad de participantes por días asistidos
$conteo_dias = [];
while ($row = $result_dias_asistencia->fetch_assoc()) {
    $dias_asistidos = $row['dias_asistidos'];
    if (!isset($conteo_dias[$dias_asistidos])) {
        $conteo_dias[$dias_asistidos] = 0;
    }
    $conteo_dias[$dias_asistidos]++;
}


// Consulta para obtener los participantes y los días que asistieron
$sql_participantes_asistencia = "
      SELECT 
        c.ID_Participante, 
        p.Nombre, 
        COUNT(DISTINCT DATE(ag.Fecha)) AS dias_asistidos
    FROM 
        clase c
    JOIN 
        agenda ag ON c.ID_Agenda = ag.ID
    JOIN 
        participante p ON c.ID_Participante = p.ID
    WHERE 
        ag.ID_Evento = ?
    GROUP BY 
        c.ID_Participante, p.Nombre
    ORDER BY 
        dias_asistidos DESC;";
$stmt_participantes_asistencia = $conn->prepare($sql_participantes_asistencia);
$stmt_participantes_asistencia->bind_param("i", $id_evento);
$stmt_participantes_asistencia->execute();
$result_participantes_asistencia = $stmt_participantes_asistencia->get_result();


// Cerrar conexión
$conn->close();





?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="/Congreso/educacion.png" type="image/x-icon">
    <!--<link rel="stylesheet" href="styles2.css">-->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <title>Estadísticas del Evento</title>


    <style>
        :root {
            --azul-oscuro: #1e2a78;
            --azul-medio: #2c3e94;
            --azul-claro: #3a5fcd;
            --naranja: #e67e22;
            --naranja-oscuro: #d35400;
            --fondo-claro: #f9f9f9;
            --sombra: 0 8px 16px rgba(0, 0, 0, 0.15);
            --radius: 14px;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', sans-serif;
            color: var(--azul-oscuro);
            background: radial-gradient(ellipse at top, #1e2a78 0%, #000c2d 100%);
            background-attachment: fixed;
            background-repeat: no-repeat;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Encabezado */
        .header {
            background: linear-gradient(135deg, var(--azul-oscuro), var(--azul-medio));
            color: white;
            padding: 18px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: var(--sombra);
            position: sticky;
            top: 0;
            z-index: 99;
        }

        .header .logo {
            font-size: 28px;
            font-weight: bold;
            text-shadow: 0 0 8px #fff;
        }

        .navbar ul {
            list-style: none;
            margin: 0;
            padding: 0;
            display: flex;
        }

        .navbar .nav-item {
            margin-left: 20px;
        }

        .navbar .nav-link {
            color: white;
            text-decoration: none;
            font-weight: 500;
            padding: 10px 18px;
            border-radius: 8px;
            transition: background 0.3s ease;
        }

        .navbar .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.2);
        }

        /* Sección de cada bloque de gráfica o tabla */
        .Grafica {
            background-color: white;
            margin: 30px auto;
            padding: 25px 30px;
            border-radius: var(--radius);
            box-shadow: var(--sombra);
            width: 95%;
            max-width: 1200px;
            overflow-x: auto;
        }

        /* Títulos */
        .titulo {
            text-align: center;
            color: var(--azul-oscuro);
            font-size: 26px;
            font-weight: bold;
            margin-bottom: 20px;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        /* Tablas */
        .mi-tabla {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .mi-tabla th,
        .mi-tabla td {
            padding: 12px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }

        .mi-tabla th {
            background-color: var(--azul-oscuro);
            color: white;
            font-weight: 600;
        }

        .mi-tabla td {
            background-color: #ffffff;
            color: #1e2a78;
        }

        .mi-tabla tr:nth-child(even) td {
            background-color: #f0f2f5;
        }

        /* Canvases */
        canvas {
            max-width: 100%;
            height: auto !important;
            margin-top: 15px;
        }

        /* Animación entrada */
        .fade-in {
            animation: fadeIn 0.8s ease-in;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>

<body class="fade-in">
    <header class="header">
        <div class="logo">Estadísticas</div>
        <nav class="navbar">
            <ul>
                <li class="nav-item"><a href='Evento_inicio.php?id=<?php echo $id_evento; ?>'
                        class="nav-link">Volver</a></li>
            </ul>
        </nav>
    </header>


    <div class='Grafica'>
        <h1 class='titulo'>Gráfica de Participantes por Actividad</h1>
        <canvas id="graficoActividades"></canvas>
        <hr>
        </hr>
        <!--<h1>Actividades y Participantes</h1>-->
        <table class='mi-tabla'>
            <tr>
                <th>Actividad</th>
                <th>Total de Participantes</th>
            </tr>
            <?php while ($row = $result_actividades->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['Actividad']); ?></td>
                    <td><?php echo htmlspecialchars($row['total_participantes']); ?></td>
                </tr>
            <?php } ?>
        </table>
    </div>

    <div class='Grafica'>
        <h1 class='titulo'>Gráfica de Participantes por Día</h1>
        <canvas id="graficoParticipacionDia"></canvas>
    </div>
    <div class='Grafica'>
        <h1 class='titulo'>Gráfica de Participantes por Hora</h1>
        <canvas id="graficoParticipacionHora"></canvas>
    </div>

    <div class='Grafica'>
        <h1 class='titulo'>Participantes por Número de Días Asistidos</h1>
        <canvas id="graficoDiasAsistencia"></canvas>
        <hr>
        </hr>
        <table class='mi-tabla'>
            <tr>
                <th>Días Asistidos</th>
                <th>Cantidad de Participantes</th>
            </tr>
            <?php foreach ($conteo_dias as $dias => $cantidad) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($dias); ?></td>
                    <td><?php echo htmlspecialchars($cantidad); ?></td>
                </tr>
            <?php } ?>
        </table>



        <h1 class='titulo'>Detalles de Participantes y Días Asistidos</h1>
        <hr>
        </hr>
        <table class='mi-tabla'>
            <tr>
                <th>ID del Participante</th>
                <th>Nombre del Participante</th>
                <th>Días Asistidos</th>
            </tr>
            <?php while ($row = $result_participantes_asistencia->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['ID_Participante']); ?></td>
                    <td><?php echo htmlspecialchars($row['Nombre']); ?></td>
                    <td><?php echo htmlspecialchars($row['dias_asistidos']); ?></td>
                </tr>
            <?php } ?>
        </table>


    </div>


    <script>
        // Datos para la gráfica de actividades
        const actividades = [];
        const participantes = [];

        <?php
        $result_actividades->data_seek(0);
        while ($row = $result_actividades->fetch_assoc()) { ?>
            actividades.push("<?php echo htmlspecialchars($row['Actividad']); ?>");
            participantes.push(<?php echo $row['total_participantes']; ?>);
        <?php } ?>

        const ctxActividades = document.getElementById('graficoActividades').getContext('2d');
        const graficoActividades = new Chart(ctxActividades, {
            type: 'bar',
            data: {
                labels: actividades,
                datasets: [{
                    label: 'Total de Participantes por Actividad',
                    data: participantes,
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Datos para la gráfica de participación por día
        const fechas = [];
        const participantesPorDia = [];

        <?php
        $result_participacion_dia->data_seek(0);
        while ($row = $result_participacion_dia->fetch_assoc()) { ?>
            fechas.push("<?php echo $row['fecha']; ?>");
            participantesPorDia.push(<?php echo $row['total_participantes']; ?>);
        <?php } ?>

        const ctxParticipacionDia = document.getElementById('graficoParticipacionDia').getContext('2d');
        const graficoParticipacionDia = new Chart(ctxParticipacionDia, {
            type: 'line',
            data: {
                labels: fechas,
                datasets: [{
                    label: 'Total de Participantes por Día',
                    data: participantesPorDia,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Datos para la gráfica de participación por hora
        const fechasHoras = [];
        const participantesPorHora = [];

        <?php
        $result_participacion_hora->data_seek(0);
        while ($row = $result_participacion_hora->fetch_assoc()) { ?>
            fechasHoras.push("<?php echo $row['fecha']; ?>     <?php echo $row['hora']; ?>:00");
            participantesPorHora.push(<?php echo $row['total_participantes']; ?>);
        <?php } ?>

        const ctxParticipacionHora = document.getElementById('graficoParticipacionHora').getContext('2d');
        const graficoParticipacionHora = new Chart(ctxParticipacionHora, {
            type: 'bar',
            data: {
                labels: fechasHoras,
                datasets: [{
                    label: 'Total de Participantes por Hora',
                    data: participantesPorHora,
                    backgroundColor: 'rgba(153, 102, 255, 0.2)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>

    <script>
        // Datos para la gráfica de participantes por días asistidos
        const diasAsistidos = [];
        const cantidadParticipantes = [];

        <?php foreach ($conteo_dias as $dias => $cantidad) { ?>
            diasAsistidos.push(<?php echo $dias; ?>);
            cantidadParticipantes.push(<?php echo $cantidad; ?>);
        <?php } ?>

        const ctxDiasAsistencia = document.getElementById('graficoDiasAsistencia').getContext('2d');
        const graficoDiasAsistencia = new Chart(ctxDiasAsistencia, {
            type: 'bar',
            data: {
                labels: diasAsistidos,
                datasets: [{
                    label: 'Cantidad de Participantes por Días Asistidos',
                    data: cantidadParticipantes,
                    backgroundColor: 'rgba(255, 159, 64, 0.2)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>

</body>

</html>