<?php
require_once __DIR__ . "/Conexiones/Conexion.php";

$id_evento = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id_evento <= 0) {
    die("Evento no válido.");
}

// Agregar premio nuevo
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['nombre']) && isset($_POST['puntos'])) {
    $nombre = $conn->real_escape_string($_POST['nombre']);
    $puntos = intval($_POST['puntos']);

    $sql_insert = "INSERT INTO premios_evento (ID_Evento, NombrePremio, PuntosNecesarios) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($sql_insert);
    $stmt->bind_param("isi", $id_evento, $nombre, $puntos);
    $stmt->execute();
    $stmt->close();
    header("Location: administrar_premios.php?id=$id_evento");
    exit;
}

// Eliminar premio
if (isset($_GET['eliminar'])) {
    $id_premio = intval($_GET['eliminar']);
    $conn->query("DELETE FROM premios_evento WHERE ID = $id_premio AND ID_Evento = $id_evento");
    header("Location: administrar_premios.php?id=$id_evento");
    exit;
}

// Obtener premios actuales
$sql = "SELECT * FROM premios_evento WHERE ID_Evento = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_evento);
$stmt->execute();
$result = $stmt->get_result();
$premios = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Administrar Premios</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <h1>🎁 Premios para el Evento #<?= $id_evento ?></h1>

    <form method="POST">
        <label>Nombre del Premio:</label>
        <input type="text" name="nombre" required>

        <label>Puntos Necesarios:</label>
        <input type="number" name="puntos" required min="1">

        <button type="submit">Agregar Premio</button>
    </form>

    <h2>Premios Actuales</h2>
    <table border="1" class="mi-tabla">
        <tr>
            <th>Nombre</th>
            <th>Puntos</th>
            <th>Acciones</th>
        </tr>
        <?php foreach ($premios as $premio): ?>
            <tr>
                <td><?= htmlspecialchars($premio['NombrePremio']) ?></td>
                <td><?= $premio['PuntosNecesarios'] ?></td>
                <td>
                    <a href="?id=<?= $id_evento ?>&eliminar=<?= $premio['ID'] ?>" onclick="return confirm('¿Eliminar este premio?')">❌ Eliminar</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <p><a href="Evento_inicio.php?id=<?= $id_evento ?>">⬅️ Volver al evento</a></p>
</body>
</html>
