<?php
require_once __DIR__ . "/Conexiones/Conexion.php";

$id_evento = isset($_GET['id']) ? intval($_GET['id']) : 0;
$id_participante = null;
$participante = null;
$puntos = 0;
$premios = [];

// Buscar puntos del participante si se ha enviado
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["qr"])) {
    // Obtener ID del QR (formato esperado: ID25ÑNombre)
    function extraer_id_participante($cadena_qr) {
    // Buscar la parte que contiene el ID
    $partes = explode("Ñ", $cadena_qr);
    foreach ($partes as $index => $parte) {
        if (trim($parte) === "ID" && isset($partes[$index + 1])) {
            return intval(trim($partes[$index + 1]));
        }
    }
    return 0; // Si no se encuentra
}

$id_participante = extraer_id_participante($_POST["qr"]);

    // Obtener datos del participante
    $sql = "SELECT * FROM participante WHERE ID = ? AND ID_Evento = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $id_participante, $id_evento);
    $stmt->execute();
    $result = $stmt->get_result();
    $participante = $result->fetch_assoc();
    $stmt->close();

    if ($participante) {
        // Obtener puntos totales del participante
        $sql_puntos = "
    SELECT 
        IFNULL(SUM(pp.puntos), 0) 
        - IFNULL((
            SELECT SUM(pe.PuntosNecesarios * c.Cantidad)
            FROM canjes c
            JOIN premios_evento pe ON c.ID_Premio = pe.ID
            WHERE c.ID_Participante = pp.id_participante
              AND c.ID_Evento = pp.id_evento
        ), 0) AS puntos_disponibles
    FROM puntos_proveedor pp
    WHERE pp.id_participante = ? AND pp.id_evento = ?
    LIMIT 1
";

$stmt = $conn->prepare($sql_puntos);
$stmt->bind_param("ii", $id_participante, $id_evento);
$stmt->execute();
$result = $stmt->get_result();
$puntos = $result->fetch_assoc()['puntos_disponibles'] ?? 0;
$stmt->close();


        // Obtener premios disponibles
        $sql_premios = "SELECT * FROM premios_evento WHERE ID_Evento = ? AND Disponible = 1";
        $stmt = $conn->prepare($sql_premios);
        $stmt->bind_param("i", $id_evento);
        $stmt->execute();
        $result = $stmt->get_result();
        $premios = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
    } else {
        echo "<p style='color:red;'>Participante no encontrado.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Canjear Premios</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
<h1>🎁 Canje de Premios - Evento #<?= $id_evento ?></h1>

<form method="POST">
    <label>Escanea QR del Participante:</label>
    <input type="text" name="qr" required autofocus>
    <button type="submit">Buscar</button>
</form>

<?php if ($participante): ?>
    <hr>
    <h2>👤 <?= htmlspecialchars($participante["Nombre"]) ?> — <?= $puntos ?> puntos</h2>

    <?php if (count($premios) === 0): ?>
        <p>No hay premios disponibles.</p>
    <?php else: ?>
        <form action="guardar_canje.php" method="POST">
            <input type="hidden" name="id_evento" value="<?= $id_evento ?>">
            <input type="hidden" name="id_participante" value="<?= $id_participante ?>">
            <table border="1" class="mi-tabla">
                <tr>
                    <th>Premio</th>
                    <th>Puntos</th>
                    <th>Máx. Canjeable</th>
                    <th>Cantidad a Canjear</th>
                </tr>
                <?php foreach ($premios as $premio): 
                    $max = floor($puntos / $premio["PuntosNecesarios"]);
                ?>
                    <tr>
                        <td><?= htmlspecialchars($premio["NombrePremio"]) ?></td>
                        <td><?= $premio["PuntosNecesarios"] ?></td>
                        <td><?= $max ?></td>
                        <td>
                            <input type="number" name="canje[<?= $premio["ID"] ?>]" value="0" min="0" max="<?= $max ?>">
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <button type="submit">✅ Confirmar Canje</button>
        </form>
    <?php endif; ?>
<?php endif; ?>

<p><a href="Evento_inicio.php?id=<?= $id_evento ?>">⬅️ Volver al evento</a></p>

</body>
</html>
