<?php
require_once 'portal_puntos/conexion_congreso.php';
require_once 'portal_puntos/conexion_facturas.php';

$evento_id = isset($_GET['evento']) ? intval($_GET['evento']) : 0;
if ($evento_id <= 0) {
    die("⚠️ ID de evento no válido.");
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Estadísticas de Facturas Canjeadas</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
  background: radial-gradient(circle at center, #0d1c3b, #1e2a78); /* nuevo fondo neón oscuro */
            color: white;
            margin: 0;
            padding: 20px;
        }

        .titulo {
            text-align: center;
            font-size: 32px;
            color: #ff7f00;
            text-shadow: 0 0 10px #ff7f00;
            margin-bottom: 30px;
        }

        .btn-volver {
            display: inline-block;
            padding: 10px 20px;
            background: #ff7f00;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(255,127,0,0.5);
            font-weight: bold;
            margin-bottom: 20px;
        }

        .tabla-container {
            max-width: 1100px;
            margin: 0 auto;
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0,0,0,0.4);
        }

        th, td {
            padding: 12px 10px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            word-wrap: break-word;
        }

        th {
            background-color: #1f1f3b;
            color: #ff7f00;
            font-weight: bold;
        }

        td {
            background-color: #2a2a40;
        }

        .no-datos {
            text-align: center;
            font-size: 18px;
            padding: 20px;
            color: #ccc;
        }
    </style>
</head>
<body>

<?php
// Obtener el nombre del evento
$sql_nombre = "SELECT name_evento FROM evento WHERE ID = ?";
$stmt_nombre = $conn->prepare($sql_nombre);
$stmt_nombre->bind_param("i", $evento_id);
$stmt_nombre->execute();
$res_nombre = $stmt_nombre->get_result();
$nombre_evento = "";
if ($row_nombre = $res_nombre->fetch_assoc()) {
    $nombre_evento = $row_nombre['name_evento'];
}
?>
<h2 class="titulo">📊 Estadísticas de Facturas Canjeadas - <?= htmlspecialchars($nombre_evento) ?> </h2>

<a href="evento_inicio.php?id=<?= $evento_id ?>" class="btn-volver">← Volver al evento</a>

<div class="tabla-container">
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Teléfono</th>
                <th>RFC</th>
                <th>Facturas Canjeadas</th>
                <th>Monto Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql_part = "SELECT DISTINCT RFC, Nombre, Telefono 
                        FROM participante 
                        WHERE ID_Evento = ?";
            $stmt = $conn->prepare($sql_part);
            $stmt->bind_param("i", $evento_id);
            $stmt->execute();
            $res_part = $stmt->get_result();

            $hay_datos = false;

            while ($row = $res_part->fetch_assoc()) {
                $rfc = $row['RFC'];
                $nombre = $row['Nombre'];
                $telefono = $row['Telefono'];

                if (!$rfc) continue;

                $sql_f = "SELECT COUNT(*) as cantidad, SUM(Total) as monto 
                          FROM facturas 
                          WHERE RFC = ? AND EstatusCanjeada = 1";
                $stmt_f = $conn_facturas->prepare($sql_f);
                $stmt_f->bind_param("s", $rfc);
                $stmt_f->execute();
                $res_f = $stmt_f->get_result();
                $fact = $res_f->fetch_assoc();

                $cant = $fact['cantidad'] ?? 0;
                $monto = $fact['monto'] ?? 0;

                if ($cant > 0) {
                    $hay_datos = true;
                    echo "<tr>
                            <td>" . htmlspecialchars($nombre) . "</td>
                            <td>" . htmlspecialchars($telefono) . "</td>
                            <td>" . htmlspecialchars($rfc) . "</td>
                            <td>$cant</td>
                            <td>$" . number_format($monto, 2) . "</td>
                          </tr>";
                }
            }

            if (!$hay_datos) {
                echo '<tr><td colspan="5" class="no-datos">No hay facturas canjeadas en este evento.</td></tr>';
            }
            ?>
        </tbody>
    </table>
</div>

</body>
</html>
