<?php
require_once "Conexiones/Conexion.php";

$evento_id = $_GET['evento'] ?? 0;

// Obtener el nombre del evento
$nombre_evento = "Evento desconocido";
$sql_nombre = "SELECT name_evento FROM evento WHERE ID = ?";
$stmt_nombre = $conn->prepare($sql_nombre);
$stmt_nombre->bind_param("i", $evento_id);
$stmt_nombre->execute();
$result_nombre = $stmt_nombre->get_result();
if ($row_nombre = $result_nombre->fetch_assoc()) {
    $nombre_evento = $row_nombre['name_evento'];
}
$stmt_nombre->close();

// Obtener totales por vendedor
$sql = "
    SELECT Vendedor, COUNT(*) AS total_clientes
    FROM participante
    WHERE ID_Evento = ?
    GROUP BY Vendedor
    ORDER BY total_clientes DESC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $evento_id);
$stmt->execute();
$result = $stmt->get_result();

$vendedores = [];
$totales = [];
$mejor_vendedor = null;
$mayor_total = 0;

while ($row = $result->fetch_assoc()) {
    $vendedores[] = $row['Vendedor'];
    $totales[] = $row['total_clientes'];

    if ($row['total_clientes'] > $mayor_total) {
        $mayor_total = $row['total_clientes'];
        $mejor_vendedor = $row['Vendedor'];
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Estadísticas por Vendedor</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
    body {
        background: linear-gradient(to right, #12172a, #1d1f3a);
        color: #f0f0f0;
        font-family: 'Poppins', sans-serif;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 1000px;
        margin: 50px auto;
        padding: 30px;
        background: rgba(30, 33, 58, 0.95);
        border-radius: 20px;
        box-shadow: 0 0 30px rgba(0, 0, 0, 0.3);
    }

    .titulo {
        text-align: center;
        font-size: 32px;
        font-weight: 600;
        color: #ffa726;
        margin-bottom: 30px;
        text-shadow: 1px 1px 5px #000;
    }

    .top-vendedor {
        background: rgba(20, 50, 40, 0.9);
        border-left: 5px solid #00e676;
        padding: 20px;
        border-radius: 12px;
            margin-top: 4%;

        font-size: 18px;
        margin-bottom: 30px;
        color: #a5ffbf;
        box-shadow: 0 0 10px rgba(0, 230, 118, 0.3);
    }

    .tabla-vendedores {
        background: #1e1e2f;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0,0,0,0.3);
    }

    .tabla-vendedores th {
        background: #0d47a1;
        color: #fff;
        text-transform: uppercase;
        font-weight: 600;
        padding: 12px;
    }

    .tabla-vendedores td {
        background: #2a2a40;
        color: #fff;
        padding: 10px;
        vertical-align: middle;
    }

    .tabla-vendedores tbody tr:hover {
        background: #33335b;
    }

    .tabla-vendedores tr.highlight {
        background: #004d40 !important;
        font-weight: bold;
        color: #a7ffeb;
    }

    canvas {
        background: #1e1e2f;
        border-radius: 12px;
        padding: 20px;
        margin-top: 30px;
        box-shadow: 0 0 15px rgba(0,0,0,0.2);
    }

    .btn-volver {
    display: inline-block;
    background: linear-gradient(90deg, #00c6ff, #0072ff);
    color: white;
    padding: 12px 25px;
    border-radius: 30px;
    text-decoration: none;
    font-weight: 600;
    transition: background 0.3s ease, transform 0.2s;
    box-shadow: 0 0 15px rgba(0, 114, 255, 0.5);
}

.btn-volver:hover {
    background: linear-gradient(90deg, #0072ff, #00c6ff);
    transform: scale(1.05);
}

</style>

</head>
<body>
<div class="container">
<h2 class="titulo">📊 Estadísticas por Vendedor - <?= htmlspecialchars($nombre_evento) ?></h2>
<div class="text-center mt-4">
    <a href="evento_inicio.php?id=<?= urlencode($evento_id) ?>" class="btn-volver">← Volver al evento</a>
</div>

    <?php if ($mejor_vendedor): ?>
        <div class="top-vendedor">
            🥇 <strong><?= htmlspecialchars($mejor_vendedor) ?></strong> fue el vendedor con más registros: <strong><?= $mayor_total ?></strong> clientes.
        </div>
    <?php else: ?>
        <div class="alert alert-warning">No hay participantes registrados para este evento.</div>
    <?php endif; ?>

<canvas id="graficaVendedores" height="150"></canvas>

    <div class="mt-5 tabla-vendedores">
        <table class="table table-bordered text-center mb-0">
            <thead>
                <tr>
                    <th>Vendedor</th>
                    <th>Total de Clientes</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($vendedores as $index => $v): ?>
<tr<?= $v === $mejor_vendedor ? ' class="highlight"' : '' ?>>
                        <td><?= htmlspecialchars($v) ?></td>
                        <td><?= $totales[$index] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('graficaVendedores').getContext('2d');
    const chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?= json_encode($vendedores) ?>,
            datasets: [{
                label: 'Clientes Registrados',
                data: <?= json_encode($totales) ?>,
                backgroundColor: 'rgba(235, 172, 54, 0.7)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1,
                borderRadius: 6
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.parsed.y + ' clientes';
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { stepSize: 1 }
                }
            }
        }
    });
</script>
</body>
</html>
