<?php
// get_agenda_evento.php
ini_set('session.cookie_httponly', true);
ini_set('session.cookie_secure', true);
session_name("CON");
session_start();

require_once __DIR__ . "/Conexiones/Conexion.php";

$evento_id = intval($_GET['evento'] ?? 0);
if (!$evento_id) { echo "<p>Evento inválido.</p>"; exit; }

$rol = $_SESSION['Rol'] ?? '';

if ($rol === 'Vendedor') {
  // Vendedor: solo NO exclusivas
  $sql = "
    SELECT ag.ID, ag.Actividad, ag.Fecha, ag.Horario, ag.Salon
    FROM agenda ag
    LEFT JOIN actividades a
      ON a.ID_Evento = ag.ID_Evento AND a.Actividad = ag.Actividad
    WHERE ag.ID_Evento = ?
      AND ag.Actividad <> 'Vacio'
      AND COALESCE(a.Exclusiva,0) = 0
    ORDER BY ag.Fecha, SUBSTRING(ag.Horario,1,5), ag.Salon
  ";
} else {
  // Gerente/Admin/Evento: todo
  $sql = "
    SELECT ID, Actividad, Fecha, Horario, Salon
    FROM agenda
    WHERE ID_Evento = ?
      AND Actividad <> 'Vacio'
    ORDER BY Fecha, SUBSTRING(Horario,1,5), Salon
  ";
}

$q = $conn->prepare($sql);
$q->bind_param("i", $evento_id);
$q->execute();
$res = $q->get_result();

$agenda = [];
while ($s = $res->fetch_assoc()) {
  $agenda[$s['Fecha']][$s['Horario']][] = $s;
}

if (empty($agenda)) {
  echo "<p>No hay actividades programadas aún para este evento.</p>";
  exit;
}

// Render (mismo formato que ya usas)
foreach ($agenda as $fecha => $porHora) {
  echo "<div style='border-left:4px solid #3da0ff;padding:8px 12px;margin:10px 0'>";
  echo "<div style='font-weight:600;margin-bottom:6px'>📅 " . htmlspecialchars($fecha) . "</div>";
  foreach ($porHora as $hora => $items) {
    echo "<div style='font-weight:600;margin:6px 0'>🕒 " . htmlspecialchars($hora) . "</div>";
    echo "<div style='display:grid;gap:8px;grid-template-columns:repeat(auto-fill,minmax(240px,1fr))'>";
    foreach ($items as $it) {
      echo "<label style='background:#1a223f;border:1px solid #31406b;border-radius:10px;padding:10px;display:block'>";
      echo "<div><strong>" . htmlspecialchars($it['Actividad']) . "</strong></div>";
      echo "<div style='font-size:12px;opacity:.85'>Salón: " . htmlspecialchars($it['Salon']) . "</div>";
      echo "<div style='font-size:12px;opacity:.85'>Horario: " . htmlspecialchars($it['Horario']) . "</div>";
      echo "<input type='checkbox' class='chk-slot' name='actividades[]' value='" . (int)$it['ID'] . "' " .
           "data-fecha='" . htmlspecialchars($it['Fecha']) . "' data-horario='" . htmlspecialchars($it['Horario']) . "'>";
      echo "</label>";
    }
    echo "</div>";
  }
  echo "</div>";
}
