<?php
require_once __DIR__ . "/Conexiones/Conexion.php";

$id_evento = intval($_POST['id_evento'] ?? 0);
$id_participante = intval($_POST['id_participante'] ?? 0);
$canje = $_POST['canje'] ?? [];

if ($id_evento <= 0 || $id_participante <= 0 || empty($canje)) {
    die("Datos inválidos.");
}

// Obtener puntos actuales
$sql = "
    SELECT GREATEST(
        IFNULL(SUM(pp.puntos), 0) 
        - IFNULL((
            SELECT SUM(pe.PuntosNecesarios * c.Cantidad)
            FROM canjes c
            JOIN premios_evento pe ON c.ID_Premio = pe.ID
            WHERE c.ID_Participante = pp.id_participante
              AND c.ID_Evento = pp.id_evento
        ), 0),
    0) AS puntos_disponibles
    FROM puntos_proveedor pp
    WHERE pp.id_participante = ? AND pp.id_evento = ?
    LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $id_participante, $id_evento);
$stmt->execute();
$result = $stmt->get_result();
$puntos_disponibles = $result->fetch_assoc()['puntos_disponibles'] ?? 0;
$stmt->close();

// Obtener premios válidos
$premios_sql = "SELECT ID, NombrePremio, PuntosNecesarios FROM premios_evento WHERE ID_Evento = ? AND Disponible = 1";
$stmt = $conn->prepare($premios_sql);
$stmt->bind_param("i", $id_evento);
$stmt->execute();
$result = $stmt->get_result();
$premios_validos = [];
while ($row = $result->fetch_assoc()) {
    $premios_validos[$row['ID']] = $row;
}
$stmt->close();

// Procesar cada premio solicitado
$total_puntos_usados = 0;
$canjes_realizados = [];

foreach ($canje as $id_premio => $cantidad) {
    $id_premio = intval($id_premio);
    $cantidad = intval($cantidad);
    if ($cantidad <= 0 || !isset($premios_validos[$id_premio])) {
        continue;
    }

    $premio = $premios_validos[$id_premio];
    $costo_total = $cantidad * $premio['PuntosNecesarios'];

    if ($puntos_disponibles >= $costo_total) {
        // Registrar canje
        $sql_insert = "INSERT INTO canjes (ID_Evento, ID_Participante, ID_Premio, Cantidad) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        $stmt->bind_param("iiii", $id_evento, $id_participante, $id_premio, $cantidad);
        $stmt->execute();
        $stmt->close();

        $puntos_disponibles -= $costo_total;
        $total_puntos_usados += $costo_total;

        $canjes_realizados[] = [
            'nombre' => $premio['NombrePremio'],
            'cantidad' => $cantidad,
            'costo' => $costo_total
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Canje Confirmado</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
<h1>🎉 Canje Realizado</h1>

<?php if (empty($canjes_realizados)): ?>
    <p>No se pudo canjear ningún premio. Verifica los puntos disponibles.</p>
<?php else: ?>
    <p>Se canjearon los siguientes premios:</p>
    <ul>
        <?php foreach ($canjes_realizados as $canje): ?>
            <li><?= $canje['cantidad'] ?> × <?= htmlspecialchars($canje['nombre']) ?> (<?= $canje['costo'] ?> pts)</li>
        <?php endforeach; ?>
    </ul>
    <p><strong>Puntos restantes:</strong> <?= $puntos_disponibles ?></p>
<?php endif; ?>

<p><a href="canjear.php?id=<?= $id_evento ?>">⬅️ Volver a canje</a></p>
<p><a href="Evento_inicio.php?id=<?= $id_evento ?>">🏠 Ir al evento</a></p>

</body>
</html>
