<?php include "Conexiones/Conexion.php"; ?>
<!DOCTYPE html>
<html lang="es">
<head>
      <link rel="icon" type="image/png" href="/congreso/educacion.png">

  <meta charset="UTF-8">
  <title>Kiosko de Puntos</title>
  <style>
  @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@600&display=swap');

html, body {
  margin: 0;
  padding: 0;
  height: 100vh;
  width: 100vw;
  font-family: 'Segoe UI', sans-serif;
  background: radial-gradient(circle at center, #1a2c4e 0%, #0c1221 100%);
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  overflow: hidden;
  position: relative;
}

/* Borde naranja brillante */
body::before {
  content: '';
  position: absolute;
  top: 2vh;
  left: 2vw;
  right: 2vw;
  bottom: 2vh;
  border: 0.3vw solid #ff7f00;
  border-radius: 2vw;
  pointer-events: none;
  box-shadow: 0 0 1vw #ff7f00;
  z-index: 0;
}

/* Título neón */
.neon-title {
  font-family: 'Orbitron', sans-serif;
  font-size: clamp(3rem, 5vw, 6rem);
  color: #ff7f00;
  text-align: center;
  margin-top: 2vh;
  text-shadow: 
    0 0 0.2vw #ff7f00,
    0 0 0.5vw #ff7f00,
    0 0 1vw #cc6600;
  z-index: 1;
}

.kiosko {
  background: linear-gradient(to bottom, #111927, #0c101b);
  border: 0.3vw solid #ff7f00;
  box-shadow: 0 0 2vw rgba(255,127,0,0.3), 0 0 3vw rgba(255,127,0,0.1);
  border-radius: 2vw;
  padding: 5vh 3vw;
  text-align: center;
  width: 90vw;
  max-width: 600px;
  z-index: 2;
}

.logo {
  width: 30vw;
  max-width: 250px;
  margin-bottom: 3vh;
}

h2 {
  font-size: clamp(1.5rem, 3vw, 3rem);
  color: #ff7f00;
  margin-bottom: 2vh;
}

input {
  padding: 1.5vh;
  width: 100%;
  font-size: clamp(1rem, 2vw, 2rem);
  border-radius: 1vw;
  border: none;
  margin-top: 1vh;
  background: #eee;
  outline: none;
}

.nombre {
  font-size: clamp(1.2rem, 2vw, 2rem);
  color: #fff;
  margin-top: 2vh;
}

.puntos {
  font-size: clamp(2rem, 4vw, 4rem);
  font-weight: bold;
  color: #00ffcc;
  margin-top: 1vh;
}

.error {
  font-size: clamp(1rem, 2vw, 2rem);
  font-weight: bold;
  color: #ff4d4d;
  margin-top: 2vh;
}

.historial {
  margin-top: 2vh;
  font-size: clamp(0.8rem, 1.5vw, 1rem);
  color: #ccc;
  text-align: left;
  background: rgba(255,255,255,0.05);
  padding: 2vh 2vw;
  border-radius: 1vw;
}

/* Check animación */
#check-animacion {
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  background: #4caf50;
  color: white;
  font-size: clamp(2rem, 6vw, 5rem);
  width: clamp(60px, 10vw, 120px);
  height: clamp(60px, 10vw, 120px);
  border-radius: 50%;
  display: none;
  align-items: center;
  justify-content: center;
  z-index: 999;
  animation: pop-check 0.6s ease;
}

@keyframes pop-check {
  0% { transform: translate(-50%, -50%) scale(0.5); opacity: 0; }
  50% { transform: translate(-50%, -50%) scale(1.1); opacity: 1; }
  100% { transform: translate(-50%, -50%) scale(1); opacity: 1; }
}


  </style>
</head>
<body>

  <div class="neon-title">CONEXIÓN 2025</div>



        <div class="contenedor">
    <div class="top-logo">
      <img src="img/Diseno_55.png" alt="Grupo Ascencio" class="logo">
    </div>
    <div class="kiosko" id="kiosko">
    <h2>Escanea tu código</h2>
    <form method="POST" action="" id="formulario">
<textarea name="codigo" id="codigo" autocomplete="off" autofocus rows="1" style="opacity:0; position:absolute;"></textarea>
    </form>

    <div id="resultado">
      <?php
      if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $codigo_raw = $_POST['codigo'];

        // Extraer ID después de "IDÑ"
      function extraer_id_qr($cadena) {
    if (preg_match('/IDÑ\s*(\d+)/i', $cadena, $m)) {
        return intval($m[1]);
    }
    echo "<script>console.log('❌ ID no extraído. Cadena: " . addslashes($cadena) . "');</script>";
    return 0;
}






$codigo_id = extraer_id_qr($codigo_raw);

        if ($codigo_id > 0) {
        // Obtener nombre del participante
$stmt = $conn->prepare("SELECT Nombre FROM participante WHERE ID = ?");
$stmt->bind_param("i", $codigo_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows > 0) {
    $part = $res->fetch_assoc();

    /* Obtener puntos ganados
    $stmt_puntos = $conn->prepare("
        SELECT 
            IFNULL(SUM(pp.puntos), 0) 
            - IFNULL((
                SELECT SUM(pe.PuntosNecesarios * c.Cantidad)
                FROM canjes c
                JOIN premios_evento pe ON c.ID_Premio = pe.ID
                WHERE c.ID_Participante = pp.id_participante
                  AND c.ID_Evento = pp.id_evento
            ), 0) AS puntos_disponibles
        FROM puntos_proveedor pp
        WHERE pp.id_participante = ? 
        LIMIT 1
    ");
    $stmt_puntos->bind_param("i", $codigo_id);
    $stmt_puntos->execute();
    $puntos_result = $stmt_puntos->get_result();
    $puntos = $puntos_result->fetch_assoc()['puntos_disponibles'] ?? 0;
    $stmt_puntos->close();
*/


// Obtener RFC del participante
// Obtener ID_Evento del participante
$stmt_evento = $conn->prepare("SELECT ID_Evento, RFC FROM participante WHERE ID = ?");
$stmt_evento->bind_param("i", $codigo_id);
$stmt_evento->execute();
$res_evento = $stmt_evento->get_result();
$datos = $res_evento->fetch_assoc();
$id_evento = $datos['ID_Evento'] ?? 0;
$rfc = $datos['RFC'] ?? '';
$stmt_evento->close();

if ($rfc === '' || $id_evento == 0) {
  echo "<div class='error'>❌ RFC o evento no encontrado para este participante.</div>";
  exit;
}

// Obtener puntos por RFC y evento
$stmt_puntos = $conn->prepare("SELECT Puntos FROM puntos_rfc WHERE RFC = ? AND ID_Evento = ?");
$stmt_puntos->bind_param("si", $rfc, $id_evento);
$stmt_puntos->execute();
$puntos_result = $stmt_puntos->get_result();
$puntos = $puntos_result->fetch_assoc()['Puntos'] ?? 0;
$stmt_puntos->close();



    // Mostrar resultado
    echo "<div class='nombre success'>👤 " . htmlspecialchars($part['Nombre']) . "</div>";
    echo "<div class='puntos success'>⭐ " . intval($puntos) . " puntos</div>";
    echo "<div class='nombre'>Grupo: $rfc</div>";



            $hist = $conn->prepare("SELECT puntos, usuario, fecha FROM puntos_proveedor WHERE id_participante = ? ORDER BY fecha DESC LIMIT 5");
            $hist->bind_param("i", $codigo_id);
            $hist->execute();
            $hist_res = $hist->get_result();

            if ($hist_res->num_rows > 0) {
              echo "<div class='historial'><strong>Últimos registros:</strong>";
              while ($h = $hist_res->fetch_assoc()) {
                echo "<p>➕ {$h['puntos']} pts por <em>{$h['usuario']}</em> - " . date("d/m/Y H:i", strtotime($h['fecha'])) . "</p>";
              }
              echo "</div>";

              
            }
          } else {
            echo "<div class='error'>❌ Participante no encontrado</div>";
          }
        } else {
          echo "<div class='error'>⚠️ Código inválido</div>";
        }
      }
      ?>
    </div>
  </div>

  <script>
let escaneando = false;
const input = document.getElementById("codigo");
const form = document.getElementById("formulario");
const resultado = document.getElementById("resultado");

setInterval(() => {
  input.focus();
}, 500);

// Escuchar el input solo si no se está procesando ya
input.addEventListener("input", () => {
  if (escaneando) return;

  const valor = input.value.trim();

  if (valor.includes("IDÑ")) {
    escaneando = true;

    setTimeout(() => {
      form.submit();
    }, 300);
  }
});

// Limpieza automática después de 7 segundos
setTimeout(() => {
  if (resultado.innerText.includes("puntos") || resultado.innerText.includes("asignados")) {
    input.value = "";
    resultado.innerHTML = "";
    escaneando = false;
  }
}, 7000);
</script>

  <div id="check-animacion">✔</div>

</body>
</html>
