<?php
session_name("CON");
session_start();

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || $_SESSION["Rol"] !== "Admin") {
    header("location: /Congreso/Sesion/login.html");
    exit;
}

require_once "Conexiones/Conexion.php";
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Participantes por RFC</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
  background: radial-gradient(circle at center, #0d1c3b, #1e2a78); /* nuevo fondo neón oscuro */
            color: white;
            padding: 20px;
        }

        .grupo {
            background: #1a1a1a;
            margin-bottom: 20px;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(255,127,0,0.2);
        }

        .grupo h3 {
            color: #ff7f00;
            margin: 0;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .grupo h3:hover {
            text-decoration: underline;
        }

        .participantes {
            display: none;
            margin-top: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            color: white;
            padding: 8px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            text-align: left;
        }

        .buscador {
            margin-bottom: 30px;
        }

        #buscarRFC {
            padding: 10px;
            font-size: 16px;
            width: 100%;
            max-width: 400px;
            border-radius: 5px;
            border: none;
            outline: none;
        }

        .btn-volver {
            margin-bottom: 20px;
            display: inline-block;
            padding: 10px 20px;
            background: #ff7f00;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(255,127,0,0.5);
        }
    </style>
</head>
<body>

    <a href="participantes.php?id=<?php echo $id; ?>" class="btn-volver">← Volver</a>

    <h2 class="titulo">Participantes por grupo (RFC)</h2>

    <div class="buscador">
        <input type="text" id="buscarRFC" placeholder="Buscar RFC...">
    </div>

    <?php
    $stmt = $conn->prepare("SELECT RFC FROM participante WHERE ID_Evento = ? GROUP BY RFC ORDER BY RFC");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();

    $rfc_array = []; // para autocompletado

   $stmt = $conn->prepare("
    SELECT RFC 
    FROM participante 
    WHERE ID_Evento = ? AND RFC IS NOT NULL AND RFC != '' 
    GROUP BY RFC 
    ORDER BY RFC
");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();

$rfc_array = []; // para autocompletado

while ($grupo = $res->fetch_assoc()) {
    $rfc = $grupo['RFC'];
    $rfc_array[] = $rfc;

    // Buscar puntos de ese RFC en este evento
    $stmt_puntos = $conn->prepare("SELECT Puntos FROM puntos_rfc WHERE RFC = ? AND ID_Evento = ?");
    $stmt_puntos->bind_param("si", $rfc, $id);
    $stmt_puntos->execute();
    $res_puntos = $stmt_puntos->get_result();
    $puntos = 0;
    if ($row_p = $res_puntos->fetch_assoc()) {
        $puntos = intval($row_p['Puntos']);
    }
    $stmt_puntos->close();

    echo "<div class='grupo' data-rfc='$rfc'>";
    echo "<h3 onclick='toggleGrupo(\"$rfc\")'>
            Grupo RFC: <span>$rfc</span> 
            <span>⭐ $puntos puntos</span>
            <span>▼</span>
          </h3>";
    echo "<div class='participantes' id='grupo_$rfc'>";

    $stmt2 = $conn->prepare("
        SELECT Nombre, Telefono, Vendedor, Sucursal 
        FROM participante 
        WHERE RFC = ? AND ID_Evento = ?
    ");
    $stmt2->bind_param("si", $rfc, $id);
    $stmt2->execute();
    $res2 = $stmt2->get_result();

    echo "<table><tr><th>Nombre</th><th>Teléfono</th><th>Vendedor</th><th>Sucursal</th></tr>";
    while ($row = $res2->fetch_assoc()) {
        echo "<tr>
                <td>" . htmlspecialchars($row['Nombre']) . "</td>
                <td>" . htmlspecialchars($row['Telefono']) . "</td>
                <td>" . htmlspecialchars($row['Vendedor']) . "</td>
                <td>" . htmlspecialchars($row['Sucursal']) . "</td>
              </tr>";
    }
    echo "</table>";
    echo "</div></div>";
}

    $stmt->close();
    ?>

<script>
    const rfcList = <?php echo json_encode($rfc_array); ?>;

    // Autocompletado básico con filtro directo
    document.getElementById("buscarRFC").addEventListener("input", function() {
        const valor = this.value.toLowerCase();
        const grupos = document.querySelectorAll(".grupo");

        grupos.forEach(grupo => {
            const rfc = grupo.getAttribute("data-rfc").toLowerCase();
            grupo.style.display = rfc.includes(valor) ? "block" : "none";
        });
    });

    function toggleGrupo(rfc) {
        const panel = document.getElementById("grupo_" + rfc);
        if (panel.style.display === "block") {
            panel.style.display = "none";
        } else {
            panel.style.display = "block";
        }
    }
</script>

</body>
</html>
