<?php
require_once __DIR__ . "/Conexiones/Conexion.php";
$id_evento = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id_evento <= 0) {
    die("Evento no válido.");
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Premios</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <h1>🎁 Panel de Premios del Evento #<?= $id_evento ?></h1>

    <div style="display: flex; flex-direction: column; gap: 20px; max-width: 400px; margin: auto;">

        <a href="administrar_premios.php?id=<?= $id_evento ?>" class="boton-panel">
            ➕ Administrar Premios del Evento
        </a>

        <a href="canjear.php?id=<?= $id_evento ?>" class="boton-panel">
            🎟 Canjear Premios para Participantes
        </a>

        <a href="Evento_inicio.php?id=<?= $id_evento ?>" class="boton-panel">
            ⬅️ Volver al Evento
        </a>

    </div>

    <style>
        .boton-panel {
            display: block;
            background-color: #4CAF50;
            color: white;
            text-align: center;
            padding: 15px;
            text-decoration: none;
            font-size: 18px;
            border-radius: 10px;
            transition: background-color 0.3s;
        }
        .boton-panel:hover {
            background-color: #45a049;
        }
        body {
            text-align: center;
            padding: 40px;
            font-family: Arial, sans-serif;
        }
    </style>
</body>
</html>
