<?php
session_name("CON");
session_start();
require_once __DIR__ . "/../Conexiones/Conexion.php";



if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || strtolower($_SESSION["Rol"]) !== "proveedor") {
   die("Acceso denegado");
   
}

$usuario = $_SESSION['username'];

$qr_texto = $_POST['codigo'] ?? '';

// Dividir usando Ñ
$partes = explode("Ñ", $qr_texto);

// Verificar si hay al menos un fragmento
if (isset($partes[0])) {
    $raw_id = trim(str_replace("ID", "", $partes[0]));

    // Eliminar todo lo que no sea dígito (por si tiene basura oculta)
$codigo = substr(preg_replace('/\D/', '', $raw_id), 0, 4);

    if ($codigo === '') {
        die("❌ ID inválido extraído del QR.");
    }

    $codigo = (int)$codigo;
} else {
    die("❌ Código QR no contiene formato esperado.");
}

echo "Procesando ID: $codigo";


// 1. Buscar al participante y su evento

if (!$codigo || !is_numeric($codigo)) {
    die("ID no es válido numéricamente: " . htmlspecialchars($codigo));
}



$stmt = $conn->prepare("SELECT ID, Nombre, ID_Evento FROM participante WHERE ID = ?");
$stmt->bind_param("i", $codigo);
$stmt->execute();
$res = $stmt->get_result();

//$res = $stmt->get_result();
if ($res->num_rows === 0) {
    die("Participante no encontrado con ID: $codigo");
    
}


if ($res->num_rows === 0) {
    die("Participante no encontrado.");
}

$participante = $res->fetch_assoc();
$id_participante = $participante['ID'];
$nombre = $participante['Nombre'];
$id_evento = $participante['ID_Evento'];

// 2. Buscar cuántos puntos puede dar el proveedor en este evento
$pstmt = $conn->prepare("SELECT Puntos FROM proveedor_evento WHERE NombreProveedor = ? AND ID_Evento = ? AND Activo = 1");
$pstmt->bind_param("si", $usuario, $id_evento);
$pstmt->execute();
$puntos_res = $pstmt->get_result();

if ($puntos_res->num_rows === 0) {
    die("⚠️ No tienes puntos configurados para este evento.");
}

$row_puntos = $puntos_res->fetch_assoc();
$puntos = intval($row_puntos['Puntos']);

// 3. Verificar si han pasado al menos 15 minutos desde la última vez
$check = $conn->prepare("
    SELECT fecha 
    FROM puntos_proveedor 
    WHERE id_participante = ? AND usuario = ? AND id_evento = ?
    ORDER BY fecha DESC 
    LIMIT 1
");
$check->bind_param("isi", $id_participante, $usuario, $id_evento);
$check->execute();
$rcheck = $check->get_result();

if ($rcheck->num_rows > 0) {
    $ultima_fecha = $rcheck->fetch_assoc()['fecha'];
    $ahora = new DateTime();
    $ultima = new DateTime($ultima_fecha);
    $diferencia = $ahora->getTimestamp() - $ultima->getTimestamp();

    if ($diferencia < 900) { // 15 minutos = 900 segundos
        die("⚠️ Debes esperar 15 minutos para volver a dar puntos a este participante.");
    }
}


// 4. Insertar puntos
//$insert = $conn->prepare("INSERT INTO puntos_proveedor (id_participante, id_evento, usuario, puntos) VALUES (?, ?, ?, ?)");
//$insert->bind_param("iisi", $id_participante, $id_evento, $usuario, $puntos);
//$insert->execute();

//echo "✅ $puntos puntos asignados a $nombre";



// 4. Insertar en historial de proveedor
$insert = $conn->prepare("INSERT INTO puntos_proveedor (id_participante, id_evento, usuario, puntos) VALUES (?, ?, ?, ?)");
$insert->bind_param("iisi", $id_participante, $id_evento, $usuario, $puntos);
$insert->execute();

// 5. Obtener RFC del participante
$stmt_rfc = $conn->prepare("SELECT RFC FROM participante WHERE ID = ?");
$stmt_rfc->bind_param("i", $id_participante);
$stmt_rfc->execute();
$res_rfc = $stmt_rfc->get_result();
$rfc = $res_rfc->fetch_assoc()['RFC'] ?? '';
$stmt_rfc->close();

// 6. Insertar o actualizar puntos en puntos_rfc por RFC + ID_Evento
$upsert = $conn->prepare("
    INSERT INTO puntos_rfc (RFC, ID_Evento, Puntos)
    VALUES (?, 3, ?)
    ON DUPLICATE KEY UPDATE Puntos = Puntos + VALUES(Puntos)
");

$upsert->bind_param("si", $rfc, $puntos);
$upsert->execute();
$upsert->close();


echo "✅ $puntos puntos asignados al grupo con RFC $rfc (modo grupal)";
