<?php
session_name("CON");
session_start();

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || strtolower($_SESSION["Rol"]) !== "proveedor") {
    header("Location: ../Sesion/login.html");
    exit;
}

$usuario = $_SESSION['username'];

require_once __DIR__ . "/../Conexiones/Conexion.php";

// Obtener cuántos puntos da este proveedor y en qué evento
$puntos = "N/A";
$evento = "Sin asignar";

$sql = "SELECT pe.Puntos, e.name_evento 
        FROM proveedor_evento pe
        JOIN evento e ON e.ID = pe.ID_Evento
        WHERE pe.NombreProveedor = ? AND pe.Activo = 1
        LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $usuario);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows > 0) {
    $row = $res->fetch_assoc();
    $puntos = $row['Puntos'];
    $evento = $row['name_evento'];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Escaneo QR - <?= htmlspecialchars($usuario) ?></title>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
  font-family: 'Segoe UI', sans-serif;
  margin: 0;
  padding: 0;
  min-height: 100vh;
  background: linear-gradient(-45deg, #f8f9fa, #dee2e6, #f1f3f5, #ffffff);
  background-size: 400% 400%;
  animation: backgroundWave 30s ease infinite;
  display: flex;
  flex-direction: column;
  align-items: center;
}

@keyframes backgroundWave {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

h2 {
  margin-top: 40px;
  font-size: 28px;
  color: #003366;
  text-shadow: 1px 1px 1px rgba(0,0,0,0.05);
}

.info {
  margin-top: 15px;
  background: #d1e7dd;
  color: #0f5132;
  padding: 14px 20px;
  font-size: 18px;
  border-radius: 12px;
  box-shadow: 0 4px 8px rgba(0,0,0,0.05);
  max-width: 90vw;
  text-align: center;
}

p {
  margin-top: 30px;
  font-size: 20px;
  color: #333;
}

#reader {
  width: 340px;
  height: 340px;
  max-width: 90vw;
  margin: 25px auto;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 0 0 6px #0d6efd33, 0 8px 24px rgba(0,0,0,0.2);
  background: white;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
}

#reader > div {
  width: 100% !important;
  height: 100% !important;
}

.resultado {
  margin-top: 20px;
  font-size: 20px;
  background: #f8f9fa;
  color: #212529;
  padding: 12px 18px;
  border-radius: 10px;
  border-left: 5px solid #0d6efd;
  animation: fadeIn 0.5s ease-in-out;
  max-width: 90vw;
  box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}

@media (max-width: 600px) {
  h2 {
    font-size: 22px;
    margin-top: 30px;
  }

  .info, .resultado {
    font-size: 16px;
    padding: 10px;
  }

  #reader {
    width: 50vw;
    height: 200px;
  }
}

.logout-btn {
  position: absolute;
  top: 20px;
  right: 20px;
  background-color: #c62828;
  color: white;
  padding: 10px 20px;
  text-decoration: none;
  border-radius: 8px;
  font-weight: bold;
  transition: background-color 0.3s;
  z-index: 1000;
}

.logout-btn:hover {
  background-color: #a61b1b;
}


    </style>
</head>
<body>
    
    <h2>Proveedor: <?= htmlspecialchars($usuario) ?></h2>
    <div class="info">Estás dando <strong><?= $puntos ?></strong> puntos por escaneo en el evento <strong><?= htmlspecialchars($evento) ?></strong>.</div>

    <p>Escanea el QR del participante</p>
    <div id="reader"></div>
    <div class="resultado" id="resultado">Esperando escaneo...</div>
           <a href="../logout.php" class="logout-btn">Cerrar sesión</a>

    <script>
        function procesarQR(codigo) {
            fetch("asignar_puntos.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: "codigo=" + encodeURIComponent(codigo)
            })
            .then(res => res.text())
            .then(data => {
                document.getElementById("resultado").innerText = data;
                setTimeout(() => {
                    document.getElementById("resultado").innerText = "Escanea otro participante...";
                    html5QrCode.start(
                        { facingMode: "environment" },
                        { fps: 10, qrbox: 250 },
                        qrCodeMessage => {
                            html5QrCode.stop();
                            procesarQR(qrCodeMessage);
                        }
                    );
                }, 2500);
            });
        }

        const html5QrCode = new Html5Qrcode("reader");
        Html5Qrcode.getCameras().then(cameras => {
            if (cameras.length) {
                html5QrCode.start(
                    { facingMode: "environment" },
                    { fps: 10, qrbox: 250 },
                    qrCodeMessage => {
                        html5QrCode.stop();
                        procesarQR(qrCodeMessage);
                    }
                );
            } else {
                document.getElementById("resultado").innerText = "No se detectó cámara.";
            }
        }).catch(err => {
            document.getElementById("resultado").innerText = "Error al acceder a la cámara.";
            console.error(err);
        });
    </script>
</body>
</html>
